/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.time.Instant;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextButton
extends Button {
    private float padding;
    private final int color;
    private Button.OnPress dynamicPress;
    private boolean isCentered;
    private Instant disabledUntil;

    public TextButton(int x, int y, int height, Component component, int color, Button.OnPress onPress) {
        this(x, y, height, component, color, false, onPress, null);
    }

    public TextButton(int x, int y, int height, Component component, int color, Button.OnPress onPress, @Nullable Instant diabledUntil) {
        this(x, y, height, component, color, false, onPress, diabledUntil);
    }

    public TextButton(int x, int y, int height, Component component, int color, boolean isCentered, Button.OnPress onPress, @Nullable Instant disabledUntil) {
        int n = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        super(x, y, n, 9, component, onPress);
        this.dynamicPress = onPress;
        this.f_93619_ = height;
        this.f_93618_ = (int)((float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.m_6035_()) * ((float)this.m_93694_() / 8.0f));
        this.color = color;
        this.isCentered = isCentered;
        if (disabledUntil != null) {
            this.disabledUntil = disabledUntil;
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.isCentered) {
            return this.f_93623_ && this.f_93624_ && mouseX > (double)this.f_93620_ - (double)this.m_5711_() * 0.5 * (double)((float)this.m_93694_() * 2.0f / 16.0f) && mouseX < (double)this.f_93620_ + (double)this.m_5711_() * 0.5 * (double)((float)this.m_93694_() * 2.0f / 16.0f) && mouseY > (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.m_93694_());
        }
        return this.f_93623_ && this.f_93624_ && mouseX > (double)this.f_93620_ && mouseX < (double)((float)this.f_93620_ + (float)this.m_5711_() * ((float)this.m_93694_() * 2.0f / 16.0f)) && mouseY > (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.m_93694_());
    }

    public int m_5711_() {
        Font font = Minecraft.m_91087_().f_91062_;
        return (int)((float)font.m_92852_((FormattedText)this.m_6035_()) * ((float)this.m_93694_() / 8.0f));
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float partialTick) {
        int color;
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        this.m_7906_(matrices, minecraft, mouseX, mouseY);
        matrices.m_85836_();
        matrices.m_85836_();
        float height = this.getPaddedHeight() - this.padding;
        matrices.m_85837_((double)((float)this.f_93620_ * (1.0f - height * 2.0f / 16.0f)), (double)((float)this.f_93621_ * (1.0f - height * 2.0f / 16.0f)), 0.0);
        matrices.m_85841_(height * 2.0f / 16.0f, height * 2.0f / 16.0f, 0.0f);
        matrices.m_85837_(0.0, (double)(this.padding / 2.0f), 0.0);
        boolean disabled = this.disabledUntil == null || Instant.now().isAfter(this.disabledUntil);
        int n = color = this.m_5953_(mouseX, mouseY) && disabled ? this.color : this.getOffColor();
        if (this.isCentered) {
            TextButton.m_93215_((PoseStack)matrices, (Font)font, (Component)this.m_6035_(), (int)this.f_93620_, (int)this.f_93621_, (int)color);
        } else {
            TextButton.m_93243_((PoseStack)matrices, (Font)font, (Component)this.m_6035_(), (int)this.f_93620_, (int)this.f_93621_, (int)color);
        }
        matrices.m_85849_();
    }

    public void m_5691_() {
        this.dynamicPress.m_93750_((Button)this);
    }

    public int m_93694_() {
        return this.f_93619_ + (int)Math.ceil(this.padding);
    }

    public float getPaddedHeight() {
        return (float)this.f_93619_ + this.padding;
    }

    public void setVerticalPadding(float padding) {
        this.padding = padding;
    }

    private int getOffColor() {
        Color c0 = Color.getColor("", this.color);
        double r = 0.5 * (double)c0.getRed() + 0.5;
        double g = 0.5 * (double)c0.getGreen() + 0.5;
        double b = 0.5 * (double)c0.getBlue() + 0.5;
        double a = 1.0;
        return new Color((int)r, (int)g, (int)b, (int)a).getRGB();
    }

    @NotNull
    public Component m_6035_() {
        if (this.disabledUntil == null) {
            return super.m_6035_();
        }
        if (Instant.now().isBefore(this.disabledUntil)) {
            return super.m_6035_().m_6881_().m_130940_(ChatFormatting.STRIKETHROUGH);
        }
        return super.m_6035_();
    }
}

